#!/bin/bash

# Expectations:
# - local-up-cluster.sh is running
# - sudo is set up (KCM will run as root)

# Result: KCM is restarted durint the test
# - old KCM logs are in /tmp/kube-controller-manager.log
# - new KCM logs are in /tmp/kcm.log

set -o errexit
set -o nounset
set -o pipefail
set -x

# Install the hacked hostpath CSI driver (https://github.com/jsafrane/csi-driver-host-path/commit/a5c858f9d9ab7f52bc9703795b12c364364704a4)
csi-driver-host-path/deploy/kubernetes-latest/deploy.sh || : # tolerate error - e.g. missing snapshot CRDs

# Wait for the CSI driver to get running
kubectl wait --for=jsonpath='{.status.readyReplicas}'=1 statefulset/csi-hostpathplugin
# Inject detach error
kubectl exec -ti -c hostpath csi-hostpathplugin-0 -- touch /tmp/detach-error

# Run application pod
kubectl create -f csi-storageclass.yaml -f csi-pvc.yaml -f csi-app1.yaml
kubectl wait --for condition=Ready=true pod/my-csi-app-1
# Delete the app
kubectl delete pod my-csi-app-1
kubectl wait --for=delete pod/my-csi-app-1

# Wait for detach error
while true; do
    if kubectl get volumeattachment -o json | grep "Simulated detach error"; then
        break
    fi
    echo "Waiting for volumeAttachment to get error..."
    sleep 1
done

KCM=$( pidof kube-controller-manager )
KCMCMD=$( xargs -0 echo < /proc/$KCM/cmdline )

# Kill KCM until it's dead
while sudo kill $KCM; do
    sleep 1
done

# Start a new KCM
sudo $KCMCMD &>/tmp/kcm.log &

# there is no way how to wait for KCM to process the volumeattachment...
sleep 10

# Create a new pod *after* KCM started processing volumeattachments
kubectl create -f csi-app2.yaml
kubectl wait --for condition=PodScheduled=true pod/my-csi-app-2

# Stop injecting errors to detach
kubectl exec -ti -c hostpath csi-hostpathplugin-0 -- rm /tmp/detach-error

# Now, the second pod should start, but it's stuck at "no relationship found between node '127.0.0.1' and this object"

# Don't forget to kill the new KCM before running local-up-cluster.sh again!
